<?php 
/**
* @title		meetcms Radio Player module
* @website		https://meetcms.com
* @copyright	Copyright (C) 2024 Meetcms. All rights reserved.
* @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
**/

defined('_JEXEC') or die;

$radio_url = htmlspecialchars($params->get('radio_url'), ENT_COMPAT, 'UTF-8');
$width = $params->get('width', '100%');
$height = $params->get('height', '50px');
$color = $params->get('color', '#000000');
$background_color = $params->get('background_color', '#ffffff');
$border_radius = $params->get('border_radius', '0px');
$radio_name =$params->get('radio_name', '');
$radio_freq =$params->get('radio_freq', '');
?>

<div class="meetcms-radio-player <?php echo $moduleclass_sfx; ?>" style="padding:<?php echo $params->get('module_padding'); ?>;">
<?php if ($radio_name): ?><div class="radio-name"><?php echo $radio_name; ?></div><?php endif;?>
<?php if ($radio_freq): ?><div class="radio-freq"><?php echo $radio_freq; ?></div><?php endif;?>
    <audio src="<?php echo $radio_url; ?>" id="meetcms-radio-player<?php echo $module->id; ?>"></audio>
	  <div class="volume-control">
    <i class="fa fa-volume-up" aria-hidden="true"></i>
    <div class="volume-slider-container">
      <div class="volume-bar-filled"></div>
      <input type="range" min="0" max="1" step="0.01" value="1" id="volume-slider<?php echo $module->id; ?>" class="volume-slider">
    </div>
  </div>
    <button id="meetcms-play-button<?php echo $module->id; ?>" class="meetcms-play-button"><i class="fa fa-play"></i></button>
    <button id="meetcms-pause-button<?php echo $module->id; ?>" class="meetcms-pause-button"><i class="fa fa-pause"></i></button>
    <div id="meetcms-controls">
        <?php if ($params->get('ShowProgressBar')==1):?>
        <div id="meetcms-progress-bar<?php echo $module->id; ?>" class="meetcms-progress-bar">
            <div id="meetcms-progress-bar-filled<?php echo $module->id; ?>" class="meetcms-progress-bar-filled"></div>
        </div><?php endif ?>
		<?php if ($params->get('ShowDuration')==1):?>
        <div id="meetcms-time">
            <span id="meetcms-elapsed-time<?php echo $module->id; ?>">00:00</span> / <span id="meetcms-remaining-time<?php echo $module->id; ?>">00:00</span>
        </div>
		<?php endif ?>
    </div>
	<?php if ($params->get('ShowEqualizer')==1):?>
	<div id="meetcms-image-container<?php echo $module->id; ?>" class="meetcms-image-container" style="display: none;"><svg xmlns="http://www.w3.org/2000/svg" id="bouncing-bars" viewBox="0 0 107 115"><g>
	<rect class="bar" transform="translate(5,0)" y="15" style="animation-duration: 2.48167s;"></rect>
	<rect class="bar" transform="translate(20,0)" y="15" style="animation-duration: 2.84617s;"></rect>
	<rect class="bar" transform="translate(35,0)" y="15" style="animation-duration: 2.17579s;"></rect>
	<rect class="bar" transform="translate(50,0)" y="15" style="animation-duration: 2.54553s;"></rect>
	<rect class="bar" transform="translate(65,0)" y="15" style="animation-duration: 2.61323s;"></rect>
	<rect class="bar" transform="translate(80,0)" y="15" style="animation-duration: 2.47367s;"></rect>
	<rect class="bar" transform="translate(95,0)" y="15" style="animation-duration: 2.84225s;"></rect></g></svg></div>
	
<div id="pause-image<?php echo $module->id; ?>" class="pause-image"> <svg  id="bouncing-bars-paused" width="72" height="28" viewBox="0 0 62 20">
  <rect width="5" height="28"  class="bar-paused" transform="translate(0,0)"  />
  <rect width="5" height="20"  class="bar-paused" transform="translate(7,8)"  />
  <rect width="5" height="28"  class="bar-paused" transform="translate(14,0)"  />
  <rect width="5" height="15"  class="bar-paused" transform="translate(21,13)"  />
  <rect width="5" height="20"  class="bar-paused" transform="translate(28,8)"  />
  <rect width="5" height="25"  class="bar-paused" transform="translate(35,3)"  />
  <rect width="5" height="28"  class="bar-paused" transform="translate(42,0)"  />
</svg> </div>
<?php endif ?>
</div>
<script>
 (function() {
    var audioPlayer = document.getElementById('meetcms-radio-player<?php echo $module->id; ?>');
    var playButton = document.getElementById('meetcms-play-button<?php echo $module->id; ?>');
    var pauseButton = document.getElementById('meetcms-pause-button<?php echo $module->id; ?>');
    var progressBar = document.getElementById('meetcms-progress-bar<?php echo $module->id; ?>');
    var progressBarFilled = document.getElementById('meetcms-progress-bar-filled<?php echo $module->id; ?>');
    var elapsedTime = document.getElementById('meetcms-elapsed-time<?php echo $module->id; ?>');
    var remainingTime = document.getElementById('meetcms-remaining-time<?php echo $module->id; ?>');
    var imageContainer = document.getElementById('meetcms-image-container<?php echo $module->id; ?>');
    var pauseImage = document.getElementById('pause-image<?php echo $module->id; ?>');
    var volumeSlider = document.getElementById('volume-slider<?php echo $module->id; ?>');
    var volumeBarFilled = document.querySelector('.volume-bar-filled');

    // Set initial volume
    volumeSlider.value = 0.5;
    audioPlayer.volume = volumeSlider.value;
    volumeBarFilled.style.width = volumeSlider.value * 100 + '%';

    // Update volume when slider is moved
    volumeSlider.addEventListener('input', function() {
      audioPlayer.volume = volumeSlider.value;
      volumeBarFilled.style.width = volumeSlider.value * 100 + '%';
    });

    // Add click event listener to play button
    playButton.addEventListener('click', function() {
      audioPlayer.play();
      imageContainer.style.display = 'block'; // show the image container
      pauseImage.style.display = 'none'; // hide the pause image
      playButton.classList.add('active');
      pauseButton.classList.remove('active');
    });

    // Add click event listener to pause button
    pauseButton.addEventListener('click', function() {
      audioPlayer.pause();
      imageContainer.style.display = 'none'; // hide the image container
      pauseImage.style.display = 'block'; // show the pause image
      pauseButton.classList.add('active');
      playButton.classList.remove('active');
    });

    // Update progress bar and time display
    audioPlayer.addEventListener('timeupdate', function() {
      var progress = audioPlayer.currentTime / audioPlayer.duration;
      progressBarFilled.style.width = progress * 100 + '%';

      // Update elapsed time
      var elapsedTimeMinutes = Math.floor(audioPlayer.currentTime / 60);
      var elapsedTimeSeconds = Math.floor(audioPlayer.currentTime % 60);
      elapsedTime.textContent = (elapsedTimeMinutes < 10 ? '0' : '') + elapsedTimeMinutes + ':' +
        (elapsedTimeSeconds < 10 ? '0' : '') + elapsedTimeSeconds;
    
    // Update remaining time
    var remainingTimeMinutes = Math.floor((audioPlayer<?php echo $module->id; ?>.duration - audioPlayer<?php echo $module->id; ?>.currentTime) / 60);
    var remainingTimeSeconds = Math.floor((audioPlayer<?php echo $module->id; ?>.duration - audioPlayer<?php echo $module->id; ?>.currentTime) % 60);
    remainingTime.textContent = (remainingTimeMinutes < 10 ? '0' : '') + remainingTimeMinutes + ':' +
                                 (remainingTimeSeconds < 10 ? '0' : '') + remainingTimeSeconds;
  });
  // Add volume control
var volumeBarFilled = document.querySelector('.meetcms-radio-player .volume-bar-filled');
var audioPlayer<?php echo $module->id; ?> = document.querySelector('.meetcms-radio-player audio');

// Set initial volume
audioPlayer<?php echo $module->id; ?>.volume = 0.5;
volumeBarFilled.style.width = audioPlayer<?php echo $module->id; ?>.volume * 100 + '%';

  // Seek when progress bar is clicked
  progressBar.addEventListener('click', function(e) {
    var rect = progressBar.getBoundingClientRect();
    var x = e.clientX - rect.left;
    var progress = x / rect.width;
    audioPlayer<?php echo $module->id; ?>.currentTime = progress * audioPlayer<?php echo $module->id; ?>.duration;
  });
})();
</script>
